Attribute VB_Name = "Constraints"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.


Sub menuConstraintsParallel()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Sub
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim objset As ObjectSet
Set objset = activePart.GetSelection("Line")

If objset.IsEmpty Then
    MsgBox "Lines not Selected"
    Exit Sub
End If

If (objset.GetAnyMember.IsA("Line")) Then

    Set it = prod.GetClass("It").CreateAObjectIt(objset)
    Set obj = it.start
    Do While it.IsActive
        If (Not (obj.GetGeometricForm.IsA("Straight"))) Then
            MsgBox "Not all entities selected are Straight lines"
            Exit Sub
        End If
       Set obj = it.Next
   Loop
    
    cfobject.MakeParallel objset
    
Else
    MsgBox "Entities selected are not lines"
End If

api.CommitCalls "ConstraintsParallel", pause

Exit Sub

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Sub

End Sub

Sub menuConstraintsPerpendicular()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Sub
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim objset As ObjectSet
Set objset = activePart.GetSelection("Line")

If objset.IsEmpty Then
    MsgBox "Lines not Selected"
    Exit Sub
End If

If (objset.GetAnyMember.IsA("Line")) Then
    
    If (objset.GetCount = 2) Then
        Set it = prod.GetClass("It").CreateAObjectIt(objset)
        Set obj = it.start
        Do While it.IsActive
            If (Not (obj.GetGeometricForm.IsA("Straight"))) Then
                MsgBox "Not all entities selected are Straight lines"
               Exit Sub
            End If
           Set obj = it.Next
       Loop
       Set it = prod.GetClass("It").CreateAObjectIt(objset)
       cfobject.MakePerpendicular it.start, it.Next
    Else
        If (objset.GetCount < 2) Then
        MsgBox "You need to select two lines"
        Else
        MsgBox "More than two lines selected"
        End If
    End If
    
Else
    MsgBox "Entities selected are not lines"
End If

api.CommitCalls "MakePerpendicular", pause

Exit Sub

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Sub

End Sub

Sub menuConstraintsColinear()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Sub
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim objset As ObjectSet
Set objset = activePart.GetSelection("Line")

If objset Is Nothing Then
    MsgBox "Lines not Selected"
    Exit Sub
End If

If (objset.GetAnyMember.IsA("Line")) Then

    Set it = prod.GetClass("It").CreateAObjectIt(objset)
    Set obj = it.start
    Do While it.IsActive
        If (Not (obj.GetGeometricForm.IsA("Straight"))) Then
            MsgBox "Not all entities selected are Straight lines"
            Exit Sub
        End If
       Set obj = it.Next
   Loop
    
    cfobject.MakeColinear objset
    
Else
    MsgBox "Entities selected are not lines"
End If

api.CommitCalls "MakeColinear", pause

Exit Sub

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Sub

End Sub

Sub menuConstraintsTangent()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Sub
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim objset As ObjectSet
Set objset = activePart.GetSelection("Line")

If objset.IsEmpty Then
    MsgBox "Lines not Selected"
    Exit Sub
End If

If (objset.GetAnyMember.IsA("Line")) Then

    If (objset.GetCount = 2) Then
        Dim line1 As aLine
        Set it = prod.GetClass("It").CreateAObjectIt(objset)
        Set line1 = it.start
   
        Dim line2 As aLine
        Set line2 = it.Next
            If (line1.GetGeometricForm.IsA("Circle") Or line2.GetGeometricForm.IsA("Circle")) Then
                If (line1.GetGeometricForm.IsA("Circle") And line2.GetGeometricForm.IsA("Circle")) Then
                    cfobject.MakeTangentCircleCircle line1, line2
                    api.CommitCalls "MakeTangentCircleCircle", pause
                    Exit Sub
                End If
                If (line1.GetGeometricForm.IsA("Straight") And line2.GetGeometricForm.IsA("Circle")) Then
                    cfobject.MakeTangentLineCircle line1, line2
                    api.CommitCalls "MakeTangentLineCircle", pause
                    Exit Sub
                End If
                If (line1.GetGeometricForm.IsA("Circle") And line2.GetGeometricForm.IsA("Straight")) Then
                    cfobject.MakeTangentLineCircle line2, line1
                    api.CommitCalls "MakeTangentLineCircle", pause
                    Exit Sub
                End If
            Else
                MsgBox "Tangent Constraint impossible between the selected lines"
            End If
    
    Else
        MsgBox "Select two lines"
    End If
    
Else
    MsgBox "Entities selected are not lines"
End If



Exit Sub

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Sub

End Sub

Sub menuConstraintsConcentric()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Sub
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim objset As ObjectSet
Set objset = activePart.GetSelection("Line")

If objset.IsEmpty Then
    MsgBox "Lines not Selected"
    Exit Sub
End If

If (objset.GetAnyMember.IsA("Line")) Then

    Set it = prod.GetClass("It").CreateAObjectIt(objset)
    Set obj = it.start
    Do While it.IsActive
        If (Not (obj.GetGeometricForm.IsA("Circle"))) Then
            MsgBox "Not all entities selected are Circles"
            Exit Sub
        End If
       Set obj = it.Next
   Loop

    
    cfobject.MakeConcentric objset
    
Else
    MsgBox "Entities selected are not lines"
End If

api.CommitCalls "MakeConcentric", pause

Exit Sub

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Sub

End Sub

Sub menuConstraintsEqualLength()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Sub
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim objset As ObjectSet
Set objset = activePart.GetSelection("Line")

If objset.IsEmpty Then
    MsgBox "Lines not Selected"
    Exit Sub
End If

If (objset.GetAnyMember.IsA("Line")) Then

    Set it = prod.GetClass("It").CreateAObjectIt(objset)
    Set obj = it.start
    Do While it.IsActive
        If (Not (obj.GetGeometricForm.IsA("Straight"))) Then
            MsgBox "Not all entities selected are Straight lines"
            Exit Sub
        End If
       Set obj = it.Next
   Loop

    
    cfobject.MakeEqualLength objset
    
Else
    MsgBox "Entities selected are not lines"
End If

api.CommitCalls "MakeEqualLength", pause

Exit Sub

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Sub

End Sub

Sub menuConstraintsEqualRadius()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Sub
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim objset As ObjectSet
Set objset = activePart.GetSelection("Line")

If objset.IsEmpty Then
    MsgBox "Lines not Selected"
    Exit Sub
End If

If (objset.GetAnyMember.IsA("Line")) Then

    Set it = prod.GetClass("It").CreateAObjectIt(objset)
    Set obj = it.start
    Do While it.IsActive
        If (Not (obj.GetGeometricForm.IsA("Circle"))) Then
            MsgBox "Not all entities selected are Circles"
            Exit Sub
        End If
       Set obj = it.Next
   Loop
    
    cfobject.MakeEqualRadius objset
    
Else
    MsgBox "Entities selected are not lines"
End If

api.CommitCalls "MakeEqualRadius", pause

Exit Sub

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Sub

End Sub

Sub menuConstraintsFixLine()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Sub
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim objset As ObjectSet
Set objset = activePart.GetSelection("Line")

If objset.IsEmpty Then
    MsgBox "Lines not Selected"
    Exit Sub
End If

If (objset.GetAnyMember.IsA("Line")) Then

    cfobject.FixLines objset
    
Else
    MsgBox "Entities selected are not lines"
End If

api.CommitCalls "FixLines", pause

Exit Sub

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Sub

End Sub

Sub menuConstraintsSize()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Sub
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0


Dim objset As ObjectSet
Set objset = activePart.GetSelection("Line")

If objset.IsEmpty Then
    MsgBox "Linenot Selected"
    Exit Sub
End If

If (objset.GetAnyMember.IsA("Line")) Then

    If (objset.GetCount = 1) Then
    
        If ((objset.GetAnyMember.GetGeometricForm.IsA("Straight"))) Then
            cfobject.ConstrainSize objset.GetAnyMember
            api.CommitCalls "ConstraintsSize", pause
            Exit Sub
        End If
        If ((objset.GetAnyMember.GetGeometricForm.IsA("Circle"))) Then
            cfobject.MakeRadialDim objset.GetAnyMember
            api.CommitCalls "MakeRadialDim", pause
            Exit Sub
        End If
    
    Else
        MsgBox "More than one line selected"
    End If
    
Else
    MsgBox "Entity selected is not a line"
End If

Exit Sub

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Sub

End Sub

Sub menuConstraintsSepartion()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Sub
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0


Dim objset As ObjectSet
Set objset = activePart.GetSelection("Line")

If objset.IsEmpty Then
    MsgBox "Lines not Selected"
    Exit Sub
End If

If (objset.GetAnyMember.IsA("Line")) Then

    If (objset.GetCount = 2) Then
    
        Set it = prod.GetClass("It").CreateAObjectIt(objset)
        Set obj = it.start
        Do While it.IsActive
                If (Not (obj.GetGeometricForm.IsA("Straight"))) Then
                        MsgBox "Not all entities selected are Straight lines"
                        Exit Sub
                End If
       Set obj = it.Next
   Loop
    Set it = prod.GetClass("It").CreateAObjectIt(objset)
    
    cfobject.ConstrainSeparationLineToLine it.start, it.Next
    
    Else
        If (objset.GetCount < 2) Then
        MsgBox "You need to select two lines"
        Else
        MsgBox "More than two lines selected"
        End If
    End If
    
Else
    MsgBox "Entities selected are not lines"
End If

api.CommitCalls "ConstrainSeparationLineToLine", pause

Exit Sub

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Sub

End Sub

Sub menuConstraintsRemove()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Sub
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0


Dim objset As ObjectSet
Set objset = activePart.GetSelection("Line")

If objset.IsEmpty Then
    MsgBox "Lines not Selected"
    Exit Sub
End If

If (objset.GetAnyMember.IsA("Line")) Then

    cfobject.RemoveConstraints objset, 2
    
Else
    MsgBox "Entities selected are not lines"
End If

api.CommitCalls "RemoveConstraints", pause

Exit Sub

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Sub

End Sub
